/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.translate.impl.deeplx.model;

import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.Token;
import io.gitlab.jfronny.commons.serialize.Transport;
import io.gitlab.jfronny.commons.serialize.emulated.DataElement;
import io.gitlab.jfronny.commons.serialize.emulated.EmulatedReader;
import io.gitlab.jfronny.commons.serialize.emulated.EmulatedWriter;
import io.gitlab.jfronny.libjf.translate.impl.deeplx.model.ResponseData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GC_ResponseData {
    public static <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(ResponseData value, Writer writer) throws TEx, MalformedDataException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        String $jsonrpc = value.jsonrpc();
        if ($jsonrpc != null || writer.isSerializeNulls()) {
            writer.name("jsonrpc");
            if ($jsonrpc == null) {
                writer.nullValue();
            } else {
                writer.value($jsonrpc);
            }
        }
        writer.name("id");
        writer.value(value.id());
        ResponseData.Result $result = value.result();
        if ($result != null || writer.isSerializeNulls()) {
            writer.name("result");
            if ($result == null) {
                writer.nullValue();
            } else {
                Result.serialize($result, writer);
            }
        }
        writer.endObject();
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> ResponseData deserialize(Reader reader) throws TEx, MalformedDataException {
        if (reader.peek() == Token.NULL) {
            reader.nextNull();
            return null;
        }
        String _jsonrpc = null;
        boolean has_jsonrpc = false;
        long _id = 0L;
        boolean has_id = false;
        ResponseData.Result _result = null;
        boolean has_result = false;
        reader.beginObject();
        block5: while (reader.hasNext()) {
            String string;
            Objects.requireNonNull(reader.nextName());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"jsonrpc", "id", "result", String.class}, (Object)string, n)) {
                case 0: {
                    if (has_jsonrpc && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: jsonrpc");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _jsonrpc = null;
                    } else {
                        _jsonrpc = reader.nextString();
                    }
                    has_jsonrpc = true;
                    continue block5;
                }
                case 1: {
                    if (has_id && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: id");
                    }
                    _id = reader.nextLong();
                    has_id = true;
                    continue block5;
                }
                case 2: {
                    if (has_result && !reader.isLenient()) {
                        throw new MalformedDataException("Duplicate entry for: result");
                    }
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        _result = null;
                    } else {
                        _result = Result.deserialize(reader);
                    }
                    has_result = true;
                    continue block5;
                }
            }
            String s = string;
            if (reader.isLenient()) {
                reader.skipValue();
                continue;
            }
            throw new MalformedDataException("Unexpected name: " + s);
        }
        reader.endObject();
        ResponseData result = new ResponseData(_jsonrpc, _id, _result);
        return result;
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> ResponseData deserialize(Reader in, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
        return (ResponseData)transport.read(in, reader -> GC_ResponseData.deserialize(reader));
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> ResponseData deserialize(String serialized, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
        try (StringReader reader = new StringReader(serialized);){
            ResponseData responseData = GC_ResponseData.deserialize(reader, transport);
            return responseData;
        }
    }

    public static ResponseData deserialize(DataElement tree) throws MalformedDataException {
        try (EmulatedReader reader = new EmulatedReader(tree);){
            ResponseData responseData = GC_ResponseData.deserialize(reader);
            return responseData;
        }
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> ResponseData deserialize(Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            ResponseData responseData = GC_ResponseData.deserialize(reader, transport);
            return responseData;
        }
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(ResponseData value, Writer out, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
        transport.write(out, writer -> GC_ResponseData.serialize(value, writer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(ResponseData value, Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
        Path temp = Files.createTempFile("serializegenerator-", ".json", new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(temp, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            GC_ResponseData.serialize(value, writer, transport);
            Files.move(temp, path, StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(temp);
        }
    }

    public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> String serializeToString(ResponseData value, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
        return transport.write(writer -> GC_ResponseData.serialize(value, writer));
    }

    public static DataElement toDataTree(ResponseData value) throws MalformedDataException {
        try (EmulatedWriter writer = new EmulatedWriter();){
            GC_ResponseData.serialize(value, writer);
            DataElement dataElement = writer.get();
            return dataElement;
        }
    }

    public static class Result {
        public static <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(ResponseData.Result value, Writer writer) throws TEx, MalformedDataException {
            String $lang;
            if (value == null) {
                writer.nullValue();
                return;
            }
            writer.beginObject();
            List<ResponseData.Result.Text> $texts = value.texts();
            if ($texts != null || writer.isSerializeNulls()) {
                writer.name("texts");
                if ($texts == null) {
                    writer.nullValue();
                } else {
                    writer.beginArray();
                    for (ResponseData.Result.Text _texts : $texts) {
                        if (_texts == null) {
                            if (!writer.isSerializeNulls()) continue;
                            writer.nullValue();
                            continue;
                        }
                        Text.serialize(_texts, writer);
                    }
                    writer.endArray();
                }
            }
            if (($lang = value.lang()) != null || writer.isSerializeNulls()) {
                writer.name("lang");
                if ($lang == null) {
                    writer.nullValue();
                } else {
                    writer.value($lang);
                }
            }
            writer.name("lang_is_confident");
            writer.value(value.langIsConfident());
            Map<String, Double> $detectedLanguages = value.detectedLanguages();
            if ($detectedLanguages != null || writer.isSerializeNulls()) {
                writer.name("detectedLanguages");
                if ($detectedLanguages == null) {
                    writer.nullValue();
                } else {
                    writer.beginObject();
                    for (Map.Entry<String, Double> _detectedLanguages : $detectedLanguages.entrySet()) {
                        if (_detectedLanguages.getKey() == null && !writer.isSerializeNulls()) continue;
                        writer.name(Objects.toString(_detectedLanguages.getKey()));
                        Double value_detectedLanguages = _detectedLanguages.getValue();
                        if (value_detectedLanguages == null) {
                            if (!writer.isSerializeNulls()) continue;
                            writer.nullValue();
                            continue;
                        }
                        writer.value(value_detectedLanguages);
                    }
                    writer.endObject();
                }
            }
            writer.endObject();
        }

        private static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> List<ResponseData.Result.Text> read$texts(Reader reader) throws TEx, MalformedDataException {
            ArrayList<ResponseData.Result.Text> list = new ArrayList<ResponseData.Result.Text>();
            if (reader.isLenient() && reader.peek() != Token.BEGIN_ARRAY) {
                list.add(Text.deserialize(reader));
                return list;
            }
            reader.beginArray();
            while (reader.hasNext()) {
                if (reader.peek() == Token.NULL) {
                    reader.nextNull();
                    list.add(null);
                    continue;
                }
                list.add(Text.deserialize(reader));
            }
            reader.endArray();
            return list;
        }

        private static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> Map<String, Double> read$detectedLanguages(Reader reader) throws TEx, MalformedDataException {
            LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (reader.peek() == Token.NULL) {
                    reader.nextNull();
                    map.put(name, null);
                    continue;
                }
                map.put(name, reader.nextDouble());
            }
            reader.endObject();
            return map;
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> ResponseData.Result deserialize(Reader reader) throws TEx, MalformedDataException {
            if (reader.peek() == Token.NULL) {
                reader.nextNull();
                return null;
            }
            List<ResponseData.Result.Text> _texts = null;
            boolean has_texts = false;
            String _lang = null;
            boolean has_lang = false;
            boolean _langIsConfident = false;
            boolean has_langIsConfident = false;
            Map<String, Double> _detectedLanguages = null;
            boolean has_detectedLanguages = false;
            reader.beginObject();
            block6: while (reader.hasNext()) {
                String string;
                Objects.requireNonNull(reader.nextName());
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"texts", "lang", "lang_is_confident", "detectedLanguages", String.class}, (Object)string, n)) {
                    case 0: {
                        if (has_texts && !reader.isLenient()) {
                            throw new MalformedDataException("Duplicate entry for: texts");
                        }
                        if (reader.peek() == Token.NULL) {
                            reader.nextNull();
                            _texts = null;
                        } else {
                            _texts = Result.read$texts(reader);
                        }
                        has_texts = true;
                        continue block6;
                    }
                    case 1: {
                        if (has_lang && !reader.isLenient()) {
                            throw new MalformedDataException("Duplicate entry for: lang");
                        }
                        if (reader.peek() == Token.NULL) {
                            reader.nextNull();
                            _lang = null;
                        } else {
                            _lang = reader.nextString();
                        }
                        has_lang = true;
                        continue block6;
                    }
                    case 2: {
                        if (has_langIsConfident && !reader.isLenient()) {
                            throw new MalformedDataException("Duplicate entry for: lang_is_confident");
                        }
                        _langIsConfident = reader.nextBoolean();
                        has_langIsConfident = true;
                        continue block6;
                    }
                    case 3: {
                        if (has_detectedLanguages && !reader.isLenient()) {
                            throw new MalformedDataException("Duplicate entry for: detectedLanguages");
                        }
                        if (reader.peek() == Token.NULL) {
                            reader.nextNull();
                            _detectedLanguages = null;
                        } else {
                            _detectedLanguages = Result.read$detectedLanguages(reader);
                        }
                        has_detectedLanguages = true;
                        continue block6;
                    }
                }
                String s = string;
                if (reader.isLenient()) {
                    reader.skipValue();
                    continue;
                }
                throw new MalformedDataException("Unexpected name: " + s);
            }
            reader.endObject();
            ResponseData.Result result = new ResponseData.Result(_texts, _lang, _langIsConfident, _detectedLanguages);
            return result;
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> ResponseData.Result deserialize(Reader in, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
            return (ResponseData.Result)transport.read(in, reader -> Result.deserialize(reader));
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> ResponseData.Result deserialize(String serialized, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
            try (StringReader reader = new StringReader(serialized);){
                ResponseData.Result result = Result.deserialize(reader, transport);
                return result;
            }
        }

        public static ResponseData.Result deserialize(DataElement tree) throws MalformedDataException {
            try (EmulatedReader reader = new EmulatedReader(tree);){
                ResponseData.Result result = Result.deserialize(reader);
                return result;
            }
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> ResponseData.Result deserialize(Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                ResponseData.Result result = Result.deserialize(reader, transport);
                return result;
            }
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(ResponseData.Result value, Writer out, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
            transport.write(out, writer -> Result.serialize(value, writer));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(ResponseData.Result value, Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
            Path temp = Files.createTempFile("serializegenerator-", ".json", new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(temp, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                Result.serialize(value, writer, transport);
                Files.move(temp, path, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                Files.deleteIfExists(temp);
            }
        }

        public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> String serializeToString(ResponseData.Result value, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
            return transport.write(writer -> Result.serialize(value, writer));
        }

        public static DataElement toDataTree(ResponseData.Result value) throws MalformedDataException {
            try (EmulatedWriter writer = new EmulatedWriter();){
                Result.serialize(value, writer);
                DataElement dataElement = writer.get();
                return dataElement;
            }
        }

        public static class Text {
            public static <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(ResponseData.Result.Text value, Writer writer) throws TEx, MalformedDataException {
                String $text;
                if (value == null) {
                    writer.nullValue();
                    return;
                }
                writer.beginObject();
                List<ResponseData.Result.Text.Alternative> $alternatives = value.alternatives();
                if ($alternatives != null || writer.isSerializeNulls()) {
                    writer.name("alternatives");
                    if ($alternatives == null) {
                        writer.nullValue();
                    } else {
                        writer.beginArray();
                        for (ResponseData.Result.Text.Alternative _alternatives : $alternatives) {
                            if (_alternatives == null) {
                                if (!writer.isSerializeNulls()) continue;
                                writer.nullValue();
                                continue;
                            }
                            Alternative.serialize(_alternatives, writer);
                        }
                        writer.endArray();
                    }
                }
                if (($text = value.text()) != null || writer.isSerializeNulls()) {
                    writer.name("text");
                    if ($text == null) {
                        writer.nullValue();
                    } else {
                        writer.value($text);
                    }
                }
                writer.endObject();
            }

            private static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> List<ResponseData.Result.Text.Alternative> read$alternatives(Reader reader) throws TEx, MalformedDataException {
                ArrayList<ResponseData.Result.Text.Alternative> list = new ArrayList<ResponseData.Result.Text.Alternative>();
                if (reader.isLenient() && reader.peek() != Token.BEGIN_ARRAY) {
                    list.add(Alternative.deserialize(reader));
                    return list;
                }
                reader.beginArray();
                while (reader.hasNext()) {
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        list.add(null);
                        continue;
                    }
                    list.add(Alternative.deserialize(reader));
                }
                reader.endArray();
                return list;
            }

            public static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> ResponseData.Result.Text deserialize(Reader reader) throws TEx, MalformedDataException {
                if (reader.peek() == Token.NULL) {
                    reader.nextNull();
                    return null;
                }
                List<ResponseData.Result.Text.Alternative> _alternatives = null;
                boolean has_alternatives = false;
                String _text = null;
                boolean has_text = false;
                reader.beginObject();
                block4: while (reader.hasNext()) {
                    String string;
                    Objects.requireNonNull(reader.nextName());
                    int n = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"alternatives", "text", String.class}, (Object)string, n)) {
                        case 0: {
                            if (has_alternatives && !reader.isLenient()) {
                                throw new MalformedDataException("Duplicate entry for: alternatives");
                            }
                            if (reader.peek() == Token.NULL) {
                                reader.nextNull();
                                _alternatives = null;
                            } else {
                                _alternatives = Text.read$alternatives(reader);
                            }
                            has_alternatives = true;
                            continue block4;
                        }
                        case 1: {
                            if (has_text && !reader.isLenient()) {
                                throw new MalformedDataException("Duplicate entry for: text");
                            }
                            if (reader.peek() == Token.NULL) {
                                reader.nextNull();
                                _text = null;
                            } else {
                                _text = reader.nextString();
                            }
                            has_text = true;
                            continue block4;
                        }
                    }
                    String s = string;
                    if (reader.isLenient()) {
                        reader.skipValue();
                        continue;
                    }
                    throw new MalformedDataException("Unexpected name: " + s);
                }
                reader.endObject();
                ResponseData.Result.Text result = new ResponseData.Result.Text(_alternatives, _text);
                return result;
            }

            public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> ResponseData.Result.Text deserialize(Reader in, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
                return (ResponseData.Result.Text)transport.read(in, reader -> Text.deserialize(reader));
            }

            public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> ResponseData.Result.Text deserialize(String serialized, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
                try (StringReader reader = new StringReader(serialized);){
                    ResponseData.Result.Text text = Text.deserialize(reader, transport);
                    return text;
                }
            }

            public static ResponseData.Result.Text deserialize(DataElement tree) throws MalformedDataException {
                try (EmulatedReader reader = new EmulatedReader(tree);){
                    ResponseData.Result.Text text = Text.deserialize(reader);
                    return text;
                }
            }

            public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> ResponseData.Result.Text deserialize(Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
                try (BufferedReader reader = Files.newBufferedReader(path);){
                    ResponseData.Result.Text text = Text.deserialize(reader, transport);
                    return text;
                }
            }

            public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(ResponseData.Result.Text value, Writer out, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
                transport.write(out, writer -> Text.serialize(value, writer));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(ResponseData.Result.Text value, Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
                Path temp = Files.createTempFile("serializegenerator-", ".json", new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(temp, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                    Text.serialize(value, writer, transport);
                    Files.move(temp, path, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    Files.deleteIfExists(temp);
                }
            }

            public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> String serializeToString(ResponseData.Result.Text value, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
                return transport.write(writer -> Text.serialize(value, writer));
            }

            public static DataElement toDataTree(ResponseData.Result.Text value) throws MalformedDataException {
                try (EmulatedWriter writer = new EmulatedWriter();){
                    Text.serialize(value, writer);
                    DataElement dataElement = writer.get();
                    return dataElement;
                }
            }

            public static class Alternative {
                public static <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(ResponseData.Result.Text.Alternative value, Writer writer) throws TEx, MalformedDataException {
                    if (value == null) {
                        writer.nullValue();
                        return;
                    }
                    writer.beginObject();
                    String $text = value.text();
                    if ($text != null || writer.isSerializeNulls()) {
                        writer.name("text");
                        if ($text == null) {
                            writer.nullValue();
                        } else {
                            writer.value($text);
                        }
                    }
                    writer.endObject();
                }

                public static <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> ResponseData.Result.Text.Alternative deserialize(Reader reader) throws TEx, MalformedDataException {
                    if (reader.peek() == Token.NULL) {
                        reader.nextNull();
                        return null;
                    }
                    String _text = null;
                    boolean has_text = false;
                    reader.beginObject();
                    block3: while (reader.hasNext()) {
                        String string;
                        Objects.requireNonNull(reader.nextName());
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"text", String.class}, (Object)string, n)) {
                            case 0: {
                                if (has_text && !reader.isLenient()) {
                                    throw new MalformedDataException("Duplicate entry for: text");
                                }
                                if (reader.peek() == Token.NULL) {
                                    reader.nextNull();
                                    _text = null;
                                } else {
                                    _text = reader.nextString();
                                }
                                has_text = true;
                                continue block3;
                            }
                        }
                        String s = string;
                        if (reader.isLenient()) {
                            reader.skipValue();
                            continue;
                        }
                        throw new MalformedDataException("Unexpected name: " + s);
                    }
                    reader.endObject();
                    ResponseData.Result.Text.Alternative result = new ResponseData.Result.Text.Alternative(_text);
                    return result;
                }

                public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> ResponseData.Result.Text.Alternative deserialize(Reader in, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
                    return (ResponseData.Result.Text.Alternative)transport.read(in, reader -> Alternative.deserialize(reader));
                }

                public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> ResponseData.Result.Text.Alternative deserialize(String serialized, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
                    try (StringReader reader = new StringReader(serialized);){
                        ResponseData.Result.Text.Alternative alternative = Alternative.deserialize(reader, transport);
                        return alternative;
                    }
                }

                public static ResponseData.Result.Text.Alternative deserialize(DataElement tree) throws MalformedDataException {
                    try (EmulatedReader reader = new EmulatedReader(tree);){
                        ResponseData.Result.Text.Alternative alternative = Alternative.deserialize(reader);
                        return alternative;
                    }
                }

                public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> ResponseData.Result.Text.Alternative deserialize(Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
                    try (BufferedReader reader = Files.newBufferedReader(path);){
                        ResponseData.Result.Text.Alternative alternative = Alternative.deserialize(reader, transport);
                        return alternative;
                    }
                }

                public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(ResponseData.Result.Text.Alternative value, Writer out, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException {
                    transport.write(out, writer -> Alternative.serialize(value, writer));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> void serialize(ResponseData.Result.Text.Alternative value, Path path, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
                    Path temp = Files.createTempFile("serializegenerator-", ".json", new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(temp, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                        Alternative.serialize(value, writer, transport);
                        Files.move(temp, path, StandardCopyOption.REPLACE_EXISTING);
                    }
                    finally {
                        Files.deleteIfExists(temp);
                    }
                }

                public static <TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>> String serializeToString(ResponseData.Result.Text.Alternative value, Transport<TEx, Reader, Writer> transport) throws TEx, MalformedDataException, IOException {
                    return transport.write(writer -> Alternative.serialize(value, writer));
                }

                public static DataElement toDataTree(ResponseData.Result.Text.Alternative value) throws MalformedDataException {
                    try (EmulatedWriter writer = new EmulatedWriter();){
                        Alternative.serialize(value, writer);
                        DataElement dataElement = writer.get();
                        return dataElement;
                    }
                }
            }
        }
    }
}

